using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace cetvrti
{
    internal class Program
    {
        public struct T
        {
            public long x;
            public long y;
            public T(long x, long y)
            {
                this.x = x;
                this.y = y;
            }
        }
        static long gl(T a, T b, T c)
        {
            return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
        }
        static long p(List<T> om)
        {
            long ob = 0;
            int n = om.Count;
            for (int i = 0; i < n; i++)
            {
                int sl = (i + 1) % n;
                ob += om[i].x * om[sl].y;
                ob -= om[i].y * om[sl].x;
            }
            return Math.Abs(ob) / 2;
        }
        static List<T> omotac(List<T> tacke)
        {
            if (tacke.Count < 3)
                return new List<T>();
            tacke.Sort((a, b) =>
            {
                if (a.x != b.x)
                    return a.x.CompareTo(b.x);
                return a.y.CompareTo(b.y);
            });
            List<T> a1 = new List<T>();
            foreach (var x in tacke)
            {
                while (a1.Count > 1 && gl(a1[a1.Count - 2], a1[a1.Count - 1], x) <= 0)
                {
                    a1.RemoveAt(a1.Count - 1);
                }
                a1.Add(x);
            }
            List<T> b1 = new List<T>();
            for (int i = tacke.Count - 1; i >= 0; i--)
            {
                var x = tacke[i];
                while (b1.Count > 1 && gl(b1[b1.Count - 2], b1[b1.Count - 1], x) <= 0)
                {
                    b1.RemoveAt(b1.Count - 1);
                }
                b1.Add(x);
            }
            b1.RemoveAt(b1.Count - 1);
            a1.RemoveAt(a1.Count - 1);
            a1.AddRange(b1);
            return a1;
        }
        static void Main(string[] args)
        {
            int n = int.Parse(Console.ReadLine());
            List<T> t1 = new List<T>();
            for (int i = 0; i < n; i++)
            {
                string[] u = Console.ReadLine().Split();
                long x = long.Parse(u[0]);
                long y = long.Parse(u[1]);
                t1.Add(new T(x, y));
            }
            List<T> om = omotac(t1);
            if (om.Count < 3)
            {
                Console.WriteLine(0);
                return;
            }
            long min = long.MaxValue;
            for (int i = 0; i < om.Count; i++)
            {
                List<T> t = new List<T>(t1);
                t.Remove(om[i]);
                List<T> nom = omotac(t);
                long P = p(nom);
                min = Math.Min(min, P);
            }
            Console.WriteLine(min);
        }
    }
}